//
//  MCCAppVersionChecker.h
//  MCCloud
//
//  Created by Alykhan Jetha on 12-04-06.
//  Copyright (c) 2012 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

@class MCCLatestAppVersionInfo,ASIHTTPRequest;

// If the latestAppVersionInfo is nil and error is NO, that means we're up to date.
typedef void (^MCCAppVersionCheckerCallback)(BOOL error,MCCLatestAppVersionInfo *latestAppVersionInfo);

// verbose logging during version check
#define kMCCAppVersionCheckerVerboseLog @"MCCAppVersionCheckerVerboseLog"

// alternate update server url
#define kMCCAppVersionCheckerCustomBaseURLString @"MCCAppVersionCheckerCustomBaseURLString"


@interface MCCAppVersionChecker : NSObject

/*!
 Asks Cloud for the latest version of a given app. We pass along our version, system info, etc...applications calling into this should provide any other arguments they want included in the dictionary sent to the server such as cloudID if applicable, offline ID, etc
 
 If there is a new version, a callback block will be executed. The callback has one argument which is a MCCLatestAppVersionInfo.
 */
+ (ASIHTTPRequest *)versionInfoForAppWithIdentifier:(NSString *)anIdentifier additionalArguments:(NSDictionary *)additionalArguments callback:(MCCAppVersionCheckerCallback)callback;

// Ali Monday, 14 May, 2012 - The method above replaces the one below now, making this functionality more generic. Cloud based apps can pass the cloudID into additionalArguments. This is being left here as a reminder but can be removed in the future.
///*!
// Asks Cloud for the latest version of a given app. We pass along our version, account and offline ID so we can know what the user is using (for support).
//
//
// If there is a new version, aDeleg will be called back with aCallback. The callback must take one argument which is a MCCLatestAppVersionInfo.
// */
//+ (void)versionInfoForAppWithCloudID:(NSString *)cloudID delegate:(id)aDeleg newVersionCallback:(SEL)aCallback;

@end
